class GeneralSettingResponseModel {
  GeneralSettingResponseModel({
    String? remark,
    String? status,
    Message? message,
    Data? data,
  }) {
    _remark = remark;
    _status = status;
    _message = message;
    _data = data;
  }

  GeneralSettingResponseModel.fromJson(dynamic json) {
    _remark = json['remark'];
    _status = json['status'].toString();
    _message = json['message'] != null ? Message.fromJson(json['message']) : null;
    _data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }
  String? _remark;
  String? _status;
  Message? _message;
  Data? _data;

  String? get remark => _remark;
  String? get status => _status;
  Message? get message => _message;
  Data? get data => _data;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['remark'] = _remark;
    map['status'] = _status;
    if (_message != null) {
      map['message'] = _message?.toJson();
    }
    if (_data != null) {
      map['data'] = _data?.toJson();
    }
    return map;
  }
}

class Data {
    GeneralSetting? generalSetting;
    String? socialLoginRedirect;

    Data({
        this.generalSetting,
        this.socialLoginRedirect,
    });

    factory Data.fromJson(Map<String, dynamic> json) => Data(
        generalSetting: json["general_setting"] == null ? null : GeneralSetting.fromJson(json["general_setting"]),
        socialLoginRedirect: json["social_login_redirect"],
    );

    Map<String, dynamic> toJson() => {
        "general_setting": generalSetting?.toJson(),
        "social_login_redirect": socialLoginRedirect,
    };
}

class GeneralSetting {
  GeneralSetting({
    int? id,
    String? siteName,
    String? curText,
    String? curSym,
    String? emailFrom,
    String? smsBody,
    String? smsFrom,
    String? baseColor,
    String? agentFixedCommission,
    String? agentPercentCommission,
    String? referralCommission,
    String? commissionCount,
    String? userSendMoneyLimit,
    String? userDailySendMoneyLimit,
    String? userMonthlySendMoneyLimit,
    String? agentSendMoneyLimit,
    String? agentDailySendMoneyLimit,
    String? agentMonthlySendMoneyLimit,
    String? resentCodeDuration,
    SocialiteCredentials? socialiteCredentials,
    GlobalShortcodes? globalShortcodes,
    String? kv,
    String? ev,
    String? en,
    String? sv,
    String? sn,
    String? forceSsl,
    String? maintenanceMode,
    String? securePassword,
    String? agree,
    String? multiLanguage,
    String? registration,
    String? activeTemplate,
    KycModules? kycModules,
    String? referralSystem,
    String? agentModule,
    AgentCharges? agentCharges,
    dynamic createdAt,
    String? updatedAt,
  }) {
    _id = id;
    _siteName = siteName;
    _curText = curText;
    _curSym = curSym;
    _emailFrom = emailFrom;
    _smsBody = smsBody;
    _smsFrom = smsFrom;
    _baseColor = baseColor;
    _socialiteCredentials = socialiteCredentials;
    _agentFixedCommission = agentFixedCommission;
    _agentPercentCommission = agentPercentCommission;
    _referralCommission = referralCommission;
    _commissionCount = commissionCount;
    _userSendMoneyLimit = userSendMoneyLimit;
    _userDailySendMoneyLimit = userDailySendMoneyLimit;
    _userMonthlySendMoneyLimit = userMonthlySendMoneyLimit;
    _agentSendMoneyLimit = agentSendMoneyLimit;
    _agentDailySendMoneyLimit = agentDailySendMoneyLimit;
    _agentMonthlySendMoneyLimit = agentMonthlySendMoneyLimit;
    _resentCodeDuration = resentCodeDuration;
    _globalShortcodes = globalShortcodes;
    _kv = kv;
    _ev = ev;
    _en = en;
    _sv = sv;
    _sn = sn;
    _forceSsl = forceSsl;
    _maintenanceMode = maintenanceMode;
    _securePassword = securePassword;
    _agree = agree;
    _multiLanguage = multiLanguage;
    _registration = registration;
    _activeTemplate = activeTemplate;
    _kycModules = kycModules;
    _referralSystem = referralSystem;
    _agentModule = agentModule;
    _agentCharges = agentCharges;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
  }

  GeneralSetting.fromJson(dynamic json) {
    _id = json['id'];
    _siteName = json['site_name'] != null ? json['site_name'].toString() : '';
    _curText = json['cur_text'] != null ? json['cur_text'].toString() : '';
    _curSym = json['cur_sym'] != null ? json['cur_sym'].toString() : '';
    _emailFrom = json['email_from'] != null ? json['email_from'].toString() : '';
    _smsBody = json['sms_body'].toString();
    _smsFrom = json['sms_from'].toString();
    _baseColor = json['base_color'].toString();
    _agentFixedCommission = json['agent_fixed_commission'].toString();
    _agentPercentCommission = json['agent_percent_commission'].toString();
    _referralCommission = json['referral_commission'].toString();
    _commissionCount = json['commission_count'].toString();
    _socialiteCredentials = json["socialite_credentials"] == null ? null : SocialiteCredentials.fromJson(json["socialite_credentials"]);
    _userSendMoneyLimit = json['user_send_money_limit'] != null ? json['user_send_money_limit'].toString() : '';
    _userDailySendMoneyLimit = json['user_daily_send_money_limit'] != null ? json['user_daily_send_money_limit'].toString() : '';
    _userMonthlySendMoneyLimit = json['user_monthly_send_money_limit'] != null ? json['user_monthly_send_money_limit'].toString() : '';
    _agentSendMoneyLimit = json['agent_send_money_limit'] != null ? json['agent_send_money_limit'].toString() : '';
    _agentDailySendMoneyLimit = json['agent_daily_send_money_limit'] != null ? json['agent_daily_send_money_limit'].toString() : '';
    _agentMonthlySendMoneyLimit = json['agent_monthly_send_money_limit'] != null ? json['agent_monthly_send_money_limit'].toString() : '';
    _resentCodeDuration = json['resent_code_duration'].toString();
    _globalShortcodes = json['global_shortcodes'] != null ? GlobalShortcodes.fromJson(json['global_shortcodes']) : null;
    _kv = json['kv'].toString();
    _ev = json['ev'].toString();
    _en = json['en'].toString();
    _sv = json['sv'].toString();
    _sn = json['sn'].toString();
    _forceSsl = json['force_ssl'].toString();
    _maintenanceMode = json['maintenance_mode'].toString();
    _securePassword = json['secure_password'].toString();
    _agree = json['agree'] != null ? json['agree'].toString() : '';
    _multiLanguage = json['multi_language'].toString();
    _registration = json['registration'].toString();
    _activeTemplate = json['active_template'].toString();
    _kycModules = json['kyc_modules'] != null ? KycModules.fromJson(json['kyc_modules']) : null;
    _referralSystem = json['referral_system'].toString();
    _agentModule = json['agent_module'].toString();
    _agentCharges = json['agent_charges'] != null ? AgentCharges.fromJson(json['agent_charges']) : null;
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
  }
  int? _id;
  String? _siteName;
  String? _curText;
  String? _curSym;
  String? _emailFrom;
  String? _smsBody;
  String? _smsFrom;
  String? _baseColor;
  SocialiteCredentials? _socialiteCredentials;
  String? _agentFixedCommission;
  String? _agentPercentCommission;
  String? _referralCommission;
  String? _commissionCount;
  String? _userSendMoneyLimit;
  String? _userDailySendMoneyLimit;
  String? _userMonthlySendMoneyLimit;
  String? _agentSendMoneyLimit;
  String? _agentDailySendMoneyLimit;
  String? _agentMonthlySendMoneyLimit;
  String? _resentCodeDuration;
  GlobalShortcodes? _globalShortcodes;
  String? _kv;
  String? _ev;
  String? _en;
  String? _sv;
  String? _sn;
  String? _forceSsl;
  String? _maintenanceMode;
  String? _securePassword;
  String? _agree;
  String? _multiLanguage;
  String? _registration;
  String? _activeTemplate;
  KycModules? _kycModules;
  String? _referralSystem;
  String? _agentModule;
  AgentCharges? _agentCharges;
  dynamic _createdAt;
  String? _updatedAt;

  int? get id => _id;
  String? get siteName => _siteName;
  String? get curText => _curText;
  String? get curSym => _curSym;
  String? get emailFrom => _emailFrom;
  String? get smsBody => _smsBody;
  String? get smsFrom => _smsFrom;
  String? get baseColor => _baseColor;
  SocialiteCredentials? get socialiteCredentials => _socialiteCredentials;
  String? get agentFixedCommission => _agentFixedCommission;
  String? get agentPercentCommission => _agentPercentCommission;
  String? get referralCommission => _referralCommission;
  String? get commissionCount => _commissionCount;
  String? get userSendMoneyLimit => _userSendMoneyLimit;
  String? get userDailySendMoneyLimit => _userDailySendMoneyLimit;
  String? get userMonthlySendMoneyLimit => _userMonthlySendMoneyLimit;
  String? get agentSendMoneyLimit => _agentSendMoneyLimit;
  String? get agentDailySendMoneyLimit => _agentDailySendMoneyLimit;
  String? get agentMonthlySendMoneyLimit => _agentMonthlySendMoneyLimit;
  String? get resentCodeDuration => _resentCodeDuration;
  GlobalShortcodes? get globalShortcodes => _globalShortcodes;
  String? get kv => _kv;
  String? get ev => _ev;
  String? get en => _en;
  String? get sv => _sv;
  String? get sn => _sn;
  String? get forceSsl => _forceSsl;
  String? get maintenanceMode => _maintenanceMode;
  String? get securePassword => _securePassword;
  String? get agree => _agree;
  String? get multiLanguage => _multiLanguage;
  String? get registration => _registration;
  String? get activeTemplate => _activeTemplate;
  KycModules? get kycModules => _kycModules;
  String? get referralSystem => _referralSystem;
  String? get agentModule => _agentModule;
  AgentCharges? get agentCharges => _agentCharges;
  dynamic get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['site_name'] = _siteName;
    map['cur_text'] = _curText;
    map['cur_sym'] = _curSym;
    map['email_from'] = _emailFrom;
    map['sms_body'] = _smsBody;
    map['sms_from'] = _smsFrom;
    map['base_color'] = _baseColor;
    map['socialite_credentials'] = _socialiteCredentials;
    map['agent_fixed_commission'] = _agentFixedCommission;
    map['agent_percent_commission'] = _agentPercentCommission;
    map['referral_commission'] = _referralCommission;
    map['commission_count'] = _commissionCount;
    map['user_send_money_limit'] = _userSendMoneyLimit;
    map['user_daily_send_money_limit'] = _userDailySendMoneyLimit;
    map['user_monthly_send_money_limit'] = _userMonthlySendMoneyLimit;
    map['agent_send_money_limit'] = _agentSendMoneyLimit;
    map['agent_daily_send_money_limit'] = _agentDailySendMoneyLimit;
    map['agent_monthly_send_money_limit'] = _agentMonthlySendMoneyLimit;
    map['resent_code_duration'] = _resentCodeDuration;
    if (_globalShortcodes != null) {
      map['global_shortcodes'] = _globalShortcodes?.toJson();
    }
    map['kv'] = _kv;
    map['ev'] = _ev;
    map['en'] = _en;
    map['sv'] = _sv;
    map['sn'] = _sn;
    map['force_ssl'] = _forceSsl;
    map['maintenance_mode'] = _maintenanceMode;
    map['secure_password'] = _securePassword;
    map['agree'] = _agree;
    map['multi_language'] = _multiLanguage;
    map['registration'] = _registration;
    map['active_template'] = _activeTemplate;
    if (_kycModules != null) {
      map['kyc_modules'] = _kycModules?.toJson();
    }
    map['referral_system'] = _referralSystem;
    map['agent_module'] = _agentModule;
    if (_agentCharges != null) {
      map['agent_charges'] = _agentCharges?.toJson();
    }
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    return map;
  }
}

class AgentCharges {
  AgentCharges({
    String? fixedCharge,
    String? percentCharge,
  }) {
    _fixedCharge = fixedCharge;
    _percentCharge = percentCharge;
  }

  AgentCharges.fromJson(dynamic json) {
    _fixedCharge = json['fixed_charge'].toString();
    _percentCharge = json['percent_charge'].toString();
  }
  String? _fixedCharge;
  String? _percentCharge;

  String? get fixedCharge => _fixedCharge;
  String? get percentCharge => _percentCharge;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['fixed_charge'] = _fixedCharge;
    map['percent_charge'] = _percentCharge;
    return map;
  }
}

class KycModules {
  KycModules({
    Agent? agent,
    User? user,
  }) {
    _agent = agent;
    _user = user;
  }

  KycModules.fromJson(dynamic json) {
    _agent = json['agent'] != null ? Agent.fromJson(json['agent']) : null;
    _user = json['user'] != null ? User.fromJson(json['user']) : null;
  }
  Agent? _agent;
  User? _user;

  Agent? get agent => _agent;
  User? get user => _user;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_agent != null) {
      map['agent'] = _agent?.toJson();
    }
    if (_user != null) {
      map['user'] = _user?.toJson();
    }
    return map;
  }
}

class User {
  User({
    String? sendMoney,
  }) {
    _sendMoney = sendMoney;
  }

  User.fromJson(dynamic json) {
    _sendMoney = json['send_money'].toString();
  }
  String? _sendMoney;

  String? get sendMoney => _sendMoney;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['send_money'] = _sendMoney;
    return map;
  }
}

class Agent {
  Agent({
    String? payout,
    String? sendMoney,
    String? withdrawals,
  }) {
    _payout = payout;
    _sendMoney = sendMoney;
    _withdrawals = withdrawals;
  }

  Agent.fromJson(dynamic json) {
    _payout = json['payout'].toString();
    _sendMoney = json['send_money'].toString();
    _withdrawals = json['withdrawals'].toString();
  }
  String? _payout;
  String? _sendMoney;
  String? _withdrawals;

  String? get payout => _payout;
  String? get sendMoney => _sendMoney;
  String? get withdrawals => _withdrawals;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['payout'] = _payout;
    map['send_money'] = _sendMoney;
    map['withdrawals'] = _withdrawals;
    return map;
  }
}

class GlobalShortcodes {
  GlobalShortcodes({
    String? siteName,
    String? siteCurrency,
    String? currencySymbol,
  }) {
    _siteName = siteName;
    _siteCurrency = siteCurrency;
    _currencySymbol = currencySymbol;
  }

  GlobalShortcodes.fromJson(dynamic json) {
    _siteName = json['site_name'] ?? '';
    _siteCurrency = json['site_currency'] ?? '';
    _currencySymbol = json['currency_symbol'] ?? '';
  }
  String? _siteName;
  String? _siteCurrency;
  String? _currencySymbol;

  String? get siteName => _siteName;
  String? get siteCurrency => _siteCurrency;
  String? get currencySymbol => _currencySymbol;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['site_name'] = _siteName;
    map['site_currency'] = _siteCurrency;
    map['currency_symbol'] = _currencySymbol;
    return map;
  }
}

class Message {
  Message({List<String>? success, List<String>? error}) {
    _success = success;
    _error = error;
  }

  Message.fromJson(dynamic json) {
    _success = json['success'] != null ? [json['success'].toString()] : null;
    _error = json['error'] != null ? [json['error'].toString()] : null;
  }

  List<String>? _success;
  List<String>? _error;

  List<String>? get success => _success;
  List<String>? get error => _error;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['success'] = _success;
    map['error'] = _error;
    return map;
  }
}

class SocialiteCredentials {
  SocialiteCredentialsValue? google;
  SocialiteCredentialsValue? facebook;
  SocialiteCredentialsValue? linkedin;

  SocialiteCredentials({
    this.google,
    this.facebook,
    this.linkedin,
  });

  factory SocialiteCredentials.fromJson(Map<String, dynamic> json) => SocialiteCredentials(
        google: json["google"] == null ? null : SocialiteCredentialsValue.fromJson(json["google"]),
        facebook: json["facebook"] == null ? null : SocialiteCredentialsValue.fromJson(json["facebook"]),
        linkedin: json["linkedin"] == null ? null : SocialiteCredentialsValue.fromJson(json["linkedin"]),
      );

  Map<String, dynamic> toJson() => {
        "google": google?.toJson(),
        "facebook": facebook?.toJson(),
        "linkedin": linkedin?.toJson(),
      };
}

class SocialiteCredentialsValue {
  String? clientId;
  String? clientSecret;
  String? status;

  SocialiteCredentialsValue({
    this.clientId,
    this.clientSecret,
    this.status,
  });

  factory SocialiteCredentialsValue.fromJson(Map<String, dynamic> json) => SocialiteCredentialsValue(
        clientId: json["client_id"].toString(),
        clientSecret: json["client_secret"].toString(),
        status: json["status"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "client_id": clientId,
        "client_secret": clientSecret,
        "status": status,
      };
}
